%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function mesh = readmesh3vtk(filebase);

% Filenames

    filename = strcat(filebase, '.vtk')
    filenode = fopen(char(filename), 'r');



    for i=1:4
        readin = fgetl(filenode);
    end

    A = fscanf(filenode, '%s', 1);
    A = fscanf(filenode, '%d', 1);
    num_nodes = A(1)
    A = fscanf(filenode, '%s', 1);

   nodes(num_nodes,1) = 0; node(num_nodes,2)=0; node(num_nodes,3)=0;
    
    for i=1:num_nodes
         A = fscanf(filenode, '%f %f %f', 3);
         nodes(i,1) = A(1); nodes(i,2)=A(2); nodes(i,3)=A(3);
    end
    
    A = fscanf(filenode, '%s', 1);
    A = fscanf(filenode, '%d', 1);
    num_ele = A(1)
    A = fscanf(filenode, '%d', 1);
    
    ele(num_ele,1)=0; ele(num_ele,2)=0; ele(num_ele,3)=0;
    
    for i=1:num_ele
        A =  fscanf(filenode, '%d %d %d %d %d', 5);
        ele(i,1)=A(2)+1; ele(i,2)=A(3)+1; ele(i,3)=A(4)+1; ele(i,4)=A(5)+1;
    end
    
    A = fscanf(filenode, '%s', 1);
    A = fscanf(filenode, '%d', 1);
    
    for i=1:num_ele
        A =  fscanf(filenode, '%d', 1);
    end
    
    for i=1:4
        readin = fgetl(filenode);
    end 
   
    
    boundary(num_nodes)=0;
    for i=1:num_nodes
        A =  fscanf(filenode, '%d', 1);
        boundary(i)=A(1);
    end
    boundary=boundary';
    fclose(filenode);
    

%[num_nodes, num_ele] = textread(file,'%d %d',1);

%nodes = zeros(num_nodes,3);
%[nodes(:,1), nodes(:,2), nodes(:,3)] = textread(file,'%*d %f %f %f %*d',...
%   num_nodes,'headerlines',1);

%boundary = zeros(num_nodes,1);
%boundary = textread(file, '%*d %*f %*f %*f %d',num_nodes,'headerlines',1);
    
%ele=zeros(num_ele,4);
%[ele(:,1), ele(:,2), ele(:,3), ele(:,4)] = textread(file,'%*d %d %d %d %d',...
 %  num_ele,'headerlines',num_nodes+1);

%ele(:,:)=ele(:,:)+1;

mesh = struct('coords',nodes,'tris',ele,'border',boundary);
